/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.vlan;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class PortMapWidget
extends Panel
implements JDMInput {
    private static final int vlan_max_ports = 256;
    private ResourceBundle vlanBundle;
    static byte[] bitMaskArray = new byte[]{1, -128, 64, 32, 16, 8, 4, 2};
    private OctetString portMapping;
    private int numOfPorts;
    private boolean readonly = false;
    private Vector widgetList = new Vector();
    private GridLayout layout = new GridLayout();

    public PortMapWidget() {
        this.layout.setColumns(10);
        this.setLayout(this.layout);
        this.setNumOfPorts(256);
    }

    public Object getValue() {
        OctetString octetString = new OctetString("0000000000");
        int n = 0;
        while (n < this.widgetList.size()) {
            Checkbox checkbox = (Checkbox)this.widgetList.elementAt(n);
            if (checkbox.getState()) {
                this.setPortInEncodedString(n + 1, octetString);
            }
            ++n;
        }
        return octetString;
    }

    public void setValue(Object object) {
        Checkbox checkbox;
        CheckHandler checkHandler = new CheckHandler();
        this.vlanBundle = ResourceBundle.getBundle("ibm.nways.vlan.Resources");
        String string = this.vlanBundle.getString("port");
        Enumeration enumeration = this.widgetList.elements();
        while (enumeration.hasMoreElements()) {
            checkbox = (Checkbox)enumeration.nextElement();
            this.remove(checkbox);
        }
        this.widgetList.removeAllElements();
        this.layout.setRows(this.numOfPorts / 10 + 1);
        if (object instanceof OctetString) {
            this.portMapping = (OctetString)object;
            if (this.numOfPorts == 0) {
                this.numOfPorts = this.portMapping.value.length * 8;
            }
            int n = 1;
            while (n <= this.numOfPorts) {
                checkbox = new Checkbox(String.valueOf(string) + String.valueOf(n));
                checkbox.setForeground(JmaColors.textText);
                checkbox.setBackground(JmaColors.background);
                checkbox.setState(this.testPortInEncodedString(n, this.portMapping));
                if (this.readonly) {
                    checkbox.addItemListener(checkHandler);
                }
                this.add(checkbox);
                this.widgetList.addElement(checkbox);
                ++n;
            }
        }
        this.doLayout();
        this.invalidate();
    }

    public void setValue(String string) {
        try {
            OctetString octetString = new OctetString(string);
            this.setValue(octetString);
            return;
        }
        catch (Exception exception) {
            Label label = new Label();
            label.setText(string.toString());
            this.add(label);
            return;
        }
    }

    public boolean isValidValue() {
        return true;
    }

    public boolean ignoreValue() {
        return false;
    }

    public void setNumOfPorts(int n) {
        this.numOfPorts = n;
    }

    public void setReadOnly() {
        this.readonly = true;
    }

    private boolean testPortInEncodedString(int n, OctetString octetString) {
        boolean bl = false;
        int n2 = n / 8;
        if (n2 >= octetString.value.length) {
            return false;
        }
        int n3 = (n + 1) % 8;
        byte by = bitMaskArray[n3];
        bl = (octetString.value[n2] & by) == by;
        return bl;
    }

    private void setPortInEncodedString(int n, OctetString octetString) {
        int n2 = n / 8;
        if (n2 >= octetString.value.length) {
            return;
        }
        int n3 = (n + 1) % 8;
        byte by = bitMaskArray[n3];
        octetString.value[n2] = (byte)(octetString.value[n2] | by);
    }

    public class CheckHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            System.out.println("Check handler ie=" + itemEvent.toString());
            Checkbox checkbox = (Checkbox)itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1) {
                checkbox.setState(false);
            }
            if (itemEvent.getStateChange() == 2) {
                checkbox.setState(true);
            }
        }

        public CheckHandler() {
            PortMapWidget.this = PortMapWidget.this;
        }
    }
}

